/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.WailaHelper;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.mixin.BeehiveBlockEntity$BeeDataAccess;
import mcp.mobius.waila.mixin.BeehiveBlockEntityAccess;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.class_1299;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4481;
import net.minecraft.class_4482;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public enum BeehiveProvider implements IBlockComponentProvider,
IDataProvider<class_4482>
{
    INSTANCE;

    public static final IData.Type<OccupantsData> OCCUPANTS_DATA;
    public static final class_9139<class_9129, OccupantsData> OCCUPANTS_DATA_CODEC;

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        OccupantsData occupants = accessor.getData().get(OCCUPANTS_DATA);
        if (occupants != null && config.getBoolean(Options.BEE_HIVE_OCCUPANTS)) {
            Object2IntLinkedOpenHashMap names = new Object2IntLinkedOpenHashMap(occupants.occupants.size());
            for (OccupantsData.Occupant occupant : occupants.occupants) {
                class_2561 component = null;
                if (occupant.customName != null) {
                    component = class_2561.class_2562.method_10877((String)occupant.customName, (class_7225.class_7874)accessor.getWorld().method_30349());
                }
                if (component == null) {
                    component = occupant.entityType.method_5897();
                }
                String name = component.getString();
                names.put((Object)name, names.getOrDefault((Object)name, 0) + 1);
            }
            for (Object2IntMap.Entry entry : names.object2IntEntrySet()) {
                String name = (String)entry.getKey();
                int count = entry.getIntValue();
                if (count > 1) {
                    tooltip.addLine((class_2561)class_2561.method_43470((String)(count + " " + name)));
                    continue;
                }
                tooltip.addLine((class_2561)class_2561.method_43470((String)name));
            }
        }
        if (config.getBoolean(Options.BEE_HIVE_HONEY_LEVEL)) {
            class_2680 state = accessor.getBlockState();
            tooltip.addLine(new PairComponent((class_2561)class_2561.method_43471((String)"tooltip.waila.honey_level"), (class_2561)class_2561.method_43470((String)((Integer)state.method_11654((class_2769)class_4481.field_20420)).toString())));
        }
    }

    @Override
    public void appendData(IDataWriter data, IServerAccessor<class_4482> accessor, IPluginConfig config) {
        List<BeehiveBlockEntity$BeeDataAccess> stored;
        if (config.getBoolean(Options.BEE_HIVE_OCCUPANTS) && !(stored = ((BeehiveBlockEntityAccess)accessor.getTarget()).wthit_stored()).isEmpty()) {
            ArrayList<OccupantsData.Occupant> occupants = new ArrayList<OccupantsData.Occupant>(stored.size());
            for (BeehiveBlockEntity$BeeDataAccess beeData : stored) {
                class_2487 beeNbt = beeData.wthit_occupant().comp_2431().method_57463();
                Optional entityType = class_1299.method_17684((class_2487)beeNbt);
                if (entityType.isEmpty()) continue;
                String customName = beeNbt.method_10573("CustomName", 8) ? beeNbt.method_10558("CustomName") : null;
                occupants.add(new OccupantsData.Occupant((class_1299)entityType.get(), customName));
            }
            if (!occupants.isEmpty()) {
                data.addImmediate(new OccupantsData(occupants));
            }
        }
    }

    static {
        OCCUPANTS_DATA = IData.createType(class_2960.method_60656((String)"bee.occupants"));
        OCCUPANTS_DATA_CODEC = class_9139.method_56434((class_9139)class_9139.method_56435((class_9139)class_9135.method_56365((class_5321)class_7924.field_41266), OccupantsData.Occupant::entityType, WailaHelper.nullable(class_9135.field_48554), OccupantsData.Occupant::customName, OccupantsData.Occupant::new).method_56433(class_9135.method_56363()), OccupantsData::occupants, OccupantsData::new);
    }

    public record OccupantsData(List<Occupant> occupants) implements IData
    {
        @Override
        public IData.Type<? extends IData> type() {
            return OCCUPANTS_DATA;
        }

        public record Occupant(class_1299<?> entityType, @Nullable String customName) {
        }
    }
}

